// otData

/*
 common (generated from chapter2.htm)
 */
#import "OTBase.h"
#import "OTTables.h"
//#import "OTOrderedDictionary.h"

@class OTOrderedDictionary;
@class OTAnchor;

@interface OTLookupOrder : OTBaseTable {}
/*
 Dummy class; this table isn't defined, but is used, and is always NULL.
 */
@end
@interface OTFeatureParams : OTBaseTable {}
@end

@interface OTScriptList : OTBaseTable {
@public
	uint16_t _scriptCount; // Number of ScriptRecords
	NSArray * _scriptRecords; // Array of ScriptRecords -listed alphabetically by ScriptTag
}
@property (nonatomic) uint16_t scriptCount; // Number of ScriptRecords
@property (retain, nonatomic) NSArray * scriptRecords; // Array of ScriptRecords -listed alphabetically by ScriptTag


@end

@class OTScript;

@interface OTScriptRecord : OTBaseTable {
	OTScript * _script;
	NSString * _scriptTag; // 4-byte ScriptTag identifier
	NSUInteger _scriptOffsets; //Offset to Script table-from beginning of ScriptList
}
@property (retain, nonatomic) OTScript * script;
@property (retain, nonatomic) NSString * scriptTag;
@end

@class OTLangSys;

@interface OTScript : OTBaseTable {
@public
	OTLangSys * _defaultLangSys;
//	NSUInteger _defaultLangSysOffsets; //Offset to DefaultLangSys table-from beginning of Script table-may be NULL
	uint16_t _langSysCount; //Number of LangSysRecords for this script-excluding the DefaultLangSys
	NSArray * _langSysRecords; //Array of LangSysRecords-listed alphabetically by LangSysTag
}
@property (retain, nonatomic) OTLangSys * defaultLangSys;
//@property (nonatomic) NSUInteger defaultLangSysOffsets; //Offset to DefaultLangSys table-from beginning of Script table-may be NULL
@property (nonatomic) uint16_t langSysCount; //Number of LangSysRecords for this script-excluding the DefaultLangSys
@property (retain, nonatomic) NSArray * langSysRecords; //Array of LangSysRecords-listed alphabetically by LangSysTag


@end

@class OTLangSys;

@interface OTLangSysRecord : OTBaseTable {

	NSString * _langSysTag; //4-byte LangSysTag identifier
	OTLangSys * _langSys; 
//	NSUInteger _langSysOffset; //Offset to LangSys table-from beginning of Script table
}
@property (retain, nonatomic) NSString * langSysTag; //4-byte LangSysTag identifier
@property (retain, nonatomic) OTLangSys * langSys;
//@property (nonatomic) NSUInteger langSysOffset; //Offset to LangSys table-from beginning of Script table

@end


@interface OTLangSys : OTBaseTable {
	NSArray * _lookupOrder;
	NSUInteger _lookupOrderOffsets; //= NULL (reserved for an offset to a reordering table)
	uint16_t _reqFeatureIndex; //Index of a feature required for this language system- if no required features = 0xFFFF
	uint16_t _featureCount; //Number of FeatureIndex values for this language system-excludes the required feature
	NSIndexSet * _featureIndexes; //??? vielleicht NSIndexSet // Array of indices into the FeatureList-in arbitrary order 
}
@property (retain, nonatomic) NSArray * lookupOrder;
@property (nonatomic) uint16_t reqFeatureIndex;
@property (nonatomic) uint16_t featureCount;
@property (retain, nonatomic) NSIndexSet * featureIndexes;

@end


@interface OTFeatureList : OTBaseTable {
@public
	uint16_t _featureCount; //Number of FeatureRecords in this table
	NSArray * _featureRecords; //Array of FeatureRecords-zero-based (first feature has FeatureIndex = 0)-listed alphabetically by FeatureTag
}
@property (nonatomic) uint16_t featureCount;
@property (retain, nonatomic) NSArray * featureRecords;

@end

@class OTFeature;

@interface OTFeatureRecord : OTBaseTable {
	NSString * _featureTag; //4-byte feature identification tag
	NSUInteger _featureOffsets; //Offset to Feature table-from beginning of FeatureList
	OTFeature * _feature;
}
@property (retain, nonatomic) NSString * featureTag;
@property (retain, nonatomic) OTFeature * feature;

@end

@interface OTFeature : OTBaseTable {
	OTFeatureParams * _featureParams; //= NULL (reserved for offset to FeatureParams)
	uint16_t _lookupCount; //Number of LookupList indices for this feature
	NSIndexSet * _lookupListIndexes; //Array of LookupList indices for this feature -zero-based (first lookup is LookupListIndex = 0)
}
@property (retain, nonatomic) OTFeatureParams * featureParams;
@property (nonatomic) uint16_t lookupCount;
@property (retain, nonatomic) NSIndexSet * lookupListIndexes;

@end

@class OTLookup;

@interface OTLookupList : OTBaseTable {
	NSArray * _lookups;
	NSUInteger _lookupCount; //Number of lookups in this table
	NSArray * _lookupOffsets; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
}
@property (nonatomic) NSUInteger lookupCount;
@property (retain, nonatomic) NSArray * lookups;

@end


@interface OTLookup : OTBaseTable {
	NSArray * _subTables;
	NSUInteger _lookupType; //Different enumerations for GSUB and GPOS
	NSUInteger _lookupFlag; //Lookup qualifiers
	NSUInteger _subTableCount; //Number of SubTables for this lookup
}
@property (nonatomic) NSUInteger lookupType;
@property (nonatomic) NSUInteger lookupFlag;
@property (nonatomic) NSUInteger subTableCount;
@property (retain, nonatomic) NSArray * subTables;

@end

@interface OTCoverage : OTFormatSwitchingBaseTable {
	NSMutableArray * _glyphNames;
	NSMutableArray * _glyphIDs;
	uint16_t _glyphCount; //Number of glyphs in the GlyphArray
	uint16_t _rangeCount; //Number of RangeRecords
	NSArray * _rangeRecords; //Array of glyph ranges-ordered by Start GlyphID
}
@property (retain, nonatomic) NSMutableArray * glyphNames;
@property (retain, nonatomic) NSMutableArray * glyphIDs;

@property (nonatomic, retain) NSArray *rangeRecords;

@end

//@interface CoverageFormat1 : Coverage {
//@public
//	uint16_t GlyphCount; //Number of glyphs in the GlyphArray
//	NSArray * GlyphIDs; //Array of GlyphIDs-in numerical order
//}
//@end
//
//
//@interface CoverageFormat2 : Coverage {
//@public
//	uint16_t RangeCount; //Number of RangeRecords
//	NSArray * RangeRecordss; //Array of glyph ranges-ordered by Start GlyphID
//}
//@end


@interface OTRangeRecord : OTBaseTable {
@public
	NSUInteger start; //First GlyphID in the range
	NSUInteger end; //Last GlyphID in the range
	// The usage shows that it returnes strings
	//NSString * _start; //First GlyphID in the range
	//NSString * _end; //Last GlyphID in the range

	//NSRange Range; // vielleicht range benutzen???
	uint16_t _startCoverageIndex; //Coverage Index of first GlyphID in range
}
@end

@interface OTClassDef : OTFormatSwitchingBaseTable {
	NSDictionary * _classDefs;
	
	NSUInteger startGlyph; //First GlyphID of the ClassValueArray
	uint16_t glyphCount; //Size of the ClassValueArray
	NSArray * classValues; //Array of Class Values-one per GlyphID

	uint16_t classRangeCount; //Number of ClassRangeRecords
	NSArray * classRangeRecords; //Array of ClassRangeRecords-ordered by Start GlyphID

	NSString * _tagName;
	
}
@property (retain, nonatomic) NSDictionary * classDefs;
@property (retain, nonatomic) NSString* tagName;
@end

@interface OTGlyphClassDef : OTClassDef {}
@end

//@interface ClassDefFormat1 : ClassDef {
//@public
//	
//	NSUInteger StartGlyph; //First GlyphID of the ClassValueArray
//	uint16_t GlyphCount; //Size of the ClassValueArray
//	NSArray * ClassValues; //Array of Class Values-one per GlyphID
//}
//@end
//
//
//@interface ClassDefFormat2 : ClassDef {
//@public
//	uint16_t ClassRangeCount; //Number of ClassRangeRecords
//	NSArray * ClassRangeRecords; //Array of ClassRangeRecords-ordered by Start GlyphID
//}
//@end


@interface OTClassRangeRecord : OTBaseTable {
@public
	NSUInteger start; //First GlyphID in the range
	NSUInteger end; //Last GlyphID in the range
	// The usage shows that it returnes strings
//	NSString * _start; //First Glyph in the range
//	NSString * _end; //Last Glyph in the range

	uint16_t _classID; //Applied to all glyphs in the range
}
//@property (nonatomic, retain) NSString *start;
//@property (nonatomic, retain) NSString *end;
@property (nonatomic, assign) uint16_t classID;
@end


@interface OTDevice : OTBaseTable {
@public
	uint16_t _startSize; //Smallest size to correct-in ppem
	uint16_t _endSize; //Largest size to correct-in ppem
	uint16_t _deltaFormat; //Format of DeltaValue array data: 1, 2, or 3
	NSArray * _deltaValues; //Array of compressed data
}
@property (nonatomic, retain) NSArray* deltaValues;
@end

	//
	// gpos (generated from gpos.htm)
	//

@interface OTGPOS : OTBaseTable {
	OTScriptList * _scriptList;
	OTLookupList * _lookupList;
	OTFeatureList * _featureList;
	Fixed _version; //Version of the GSUB table-initially set to 0x00010000
	NSUInteger _scriptListOffset; //Offset to ScriptList table-from beginning of GSUB table
	NSUInteger _featureListOffset; //Offset to FeatureList table-from beginning of GSUB table
	NSUInteger _lookupListOffset; //Offset to LookupList table-from beginning of GSUB table
}
@property (retain, nonatomic) OTScriptList * scriptList;
@property (retain, nonatomic) OTLookupList * lookupList;
@property (retain, nonatomic) OTFeatureList * featureList;
- (OTLookup*) lookupAtIndex:(NSUInteger) Index;
- (NSString*) fdkFeatureCodeForFeature:(NSString*) FeatureTag glyphOrder:(NSArray*)GlyphOrder;

@end

@interface OTSinglePos : OTFormatSwitchingBaseTable {
	OTCoverage * _coverage; //Offset to Coverage table-from beginning of SinglePos subtable
	uint16_t _valueFormat; //Defines the types of data in the ValueRecord
	OTValueRecord * _value; //Defines positioning value(s)-applied to all glyphs in the Coverage table
	uint16_t _valueCount; //Number of ValueRecords
	NSArray * _valueRecords; //Array of ValueRecords-positioning values applied to glyphs

}
@property (nonatomic, retain) OTCoverage* coverage;
@property (nonatomic) uint16_t valueFormat;
@property (nonatomic, retain) OTValueRecord* value;
@property (nonatomic, retain) NSArray* valueRecords;

@end

@interface OTPairPos : OTFormatSwitchingBaseTable {
	OTCoverage * _coverage;
	NSArray * _pairSets; //Array of PairSets tables
	
	OTClassDef * _classDef1; //Offset to ClassDef table-from beginning of PairPos subtable-for the first glyph of the pair
	OTClassDef * _classDef2; //Offset to ClassDef table-from beginning of PairPos subtable-for the second glyph of the pair
	NSArray * _class1Records; //Array of Class1 records-ordered by Class1

@public
	uint16_t valueFormat1; //Defines the types of data in ValueRecord1-for the first glyph in the pair -may be zero (0)
	uint16_t valueFormat2; //Defines the types of data in ValueRecord2-for the second glyph in the pair -may be zero (0)
	
	uint16_t pairSetCount; //Number of PairSet tables
	uint16_t class1Count; //Number of classes in ClassDef1 table-includes Class0
	uint16_t class2Count; //Number of classes in ClassDef2 table-includes Class0
}
@property (nonatomic, retain) OTCoverage* coverage;
@property (nonatomic, retain) NSArray* pairSets;
@property (nonatomic, retain) OTClassDef* classDef1;
@property (nonatomic, retain) OTClassDef* classDef2;
@property (nonatomic, retain) NSArray* class1Records;

@end
//@interface PairPosFormat1 : OTPairPos {
//@public
//	NSUInteger CoverageOffset; //Offset to Coverage table-from beginning of PairPos subtable-only the first glyph in each pair
//	uint16_t ValueFormat1; //Defines the types of data in ValueRecord1-for the first glyph in the pair -may be zero (0)
//	uint16_t ValueFormat2; //Defines the types of data in ValueRecord2-for the second glyph in the pair -may be zero (0)
//	uint16_t PairSetCount; //Number of PairSet tables
//	NSArray * PairSetOffsets; //Array of offsets to PairSet tables-from beginning of PairPos subtable-ordered by Coverage Index
//}
//@end
//
//@interface PairPosFormat2 : OTPairPos {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of PairPos subtable-for the first glyph of the pair
//	uint16_t ValueFormat1; //ValueRecord definition-for the first glyph of the pair-may be zero (0)
//	uint16_t ValueFormat2; //ValueRecord definition-for the second glyph of the pair-may be zero (0)
//	NSUInteger OffsetClassDef1; //Offset to ClassDef table-from beginning of PairPos subtable-for the first glyph of the pair
//	NSUInteger OffsetClassDef2; //Offset to ClassDef table-from beginning of PairPos subtable-for the second glyph of the pair
//	uint16_t Class1Count; //Number of classes in ClassDef1 table-includes Class0
//	uint16_t Class2Count; //Number of classes in ClassDef2 table-includes Class0
//	NSArray * Class1Records; //Array of Class1 records-ordered by Class1
//}
//@end

@interface OTPairSet : OTBaseTable {
@public
	uint16_t pairValueCount; //Number of PairValueRecords
	NSArray * _pairValueRecords; //Array of PairValueRecords-ordered by GlyphID of the second glyph
}
@property (nonatomic, retain) NSArray* pairValueRecords;
@end


@interface OTPairValueRecord : OTBaseTable {
	
	OTValueRecord * _value1; //Positioning data for the first glyph in the pair
	OTValueRecord * _value2; //Positioning data for the second glyph in the pair
@public
	NSUInteger secondGlyph; //GlyphName of second glyph in the pair-first glyph is listed in the Coverage table
}
//@property (nonatomic, assign) NSUInteger secondGlyph;
@property (nonatomic, retain) OTValueRecord* value1;
@property (nonatomic, retain) OTValueRecord* value2;
@end


@interface OTClass1Record : OTBaseTable {
	NSArray * _class2Records; //Array of Class2 records-ordered by Class2
}
@property (nonatomic, retain) NSArray* class2Records;
@end


@interface OTClass2Record : OTBaseTable {

	OTValueRecord * _value1; //Positioning for first glyph; empty if ValueFormat1 = 0
	OTValueRecord * _value2; //Positioning for second glyph; empty if ValueFormat2 = 0
}
@property (nonatomic, retain) OTValueRecord* value1;
@property (nonatomic, retain) OTValueRecord* value2;
@end

@interface CursivePos : OTFormatSwitchingBaseTable {}
@end

@interface CursivePosFormat1 : CursivePos {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of CursivePos subtable
	uint16_t EntryExitCount; //Number of EntryExit records
	NSArray * EntryExitRecords; //Array of EntryExit records-in Coverage Index order
}
@end

@interface EntryExitRecord : OTBaseTable {
@public
	NSUInteger EntryAnchorOffsets; //Offset to EntryAnchor table-from beginning of CursivePos subtable-may be NULL
	NSUInteger ExitAnchorOffsets; //Offset to ExitAnchor table-from beginning of CursivePos subtable-may be NULL
}
@end
@interface MarkBasePos : OTFormatSwitchingBaseTable {}
@end
@interface MarkBasePosFormat1 : MarkBasePos {
@public
	NSUInteger MarkCoverageOffsets; //Offset to MarkCoverage table-from beginning of MarkBasePos subtable
	NSUInteger BaseCoverageOffsets; //Offset to BaseCoverage table-from beginning of MarkBasePos subtable
	uint16_t ClassCount; //Number of classes defined for marks
	NSUInteger MarkArrayOffsets; //Offset to MarkArray table-from beginning of MarkBasePos subtable
	NSUInteger BaseArrayOffsets; //Offset to BaseArray table-from beginning of MarkBasePos subtable
}
@end


@interface BaseArray : OTBaseTable {
@public
	uint16_t BaseCount; //Number of BaseRecords
	NSArray * BaseRecords; //Array of BaseRecords-in order of BaseCoverage Index
}
@end


@interface BaseRecord : OTBaseTable {
@public
	NSArray * BaseAnchorOffsets; //Array of offsets (one per class) to Anchor tables-from beginning of BaseArray table-ordered by class-zero-based
}
@end

@interface MarkArray : OTBaseTable {
@public
	uint16_t markCount; //Number of MarkRecords
	NSArray * markRecords; //Array of MarkRecords-in Coverage order
}
@end


@interface MarkRecord : OTBaseTable {
@public
	uint16_t classID; //Class defined for this mark
	OTAnchor * markAnchor; //Offset to Anchor table-from beginning of MarkArray table
}
@end

@interface MarkLigPos : OTFormatSwitchingBaseTable {
//@end
//
//@interface MarkLigPosFormat1 : MarkLigPos {
@public
	OTCoverage * markCoverage; //Offset to Mark Coverage table-from beginning of MarkLigPos subtable
	OTCoverage * ligatureCoverage; //Offset to Ligature Coverage table-from beginning of MarkLigPos subtable
	uint16_t classCount; //Number of defined mark classes
	MarkArray * markArray; //Offset to MarkArray table-from beginning of MarkLigPos subtable
	MarkArray * ligatureArray; //Offset to LigatureArray table-from beginning of MarkLigPos subtable
}
@end


@interface LigatureArray : OTBaseTable {
@public
	uint16_t ligatureCount; //Number of LigatureAttach table offsets
	NSArray * ligatureAttachs; //Array of offsets to LigatureAttach tables-from beginning of LigatureArray table-ordered by LigatureCoverage Index
}
@end


@interface LigatureAttach : OTBaseTable {
@public
	uint16_t componentCount; //Number of ComponentRecords in this ligature
	NSArray * componentRecords; //Array of Component records-ordered in writing direction
}
@end


@interface OTComponentRecord : OTBaseTable {
@public
	NSArray * ligatureAnchors; //Array of offsets (one per class) to Anchor tables-from beginning of LigatureAttach table-ordered by class-NULL if a component does not have an attachment for a class-zero-based array
}
@end

@interface Mark2Array : OTBaseTable {
@public
	uint16_t mark2Count; //Number of Mark2 records
	NSArray * mark2Records; //Array of Mark2 records-in Coverage order
}
@end

@interface MarkMarkPos : OTBaseTable /* OTFormatSwitchingBaseTable */ {
@public
	short posFormat;
	OTCoverage * mark1Coverage; //Offset to Combining Mark Coverage table-from beginning of MarkMarkPos subtable
	OTCoverage * mark2Coverage; //Offset to Base Mark Coverage table-from beginning of MarkMarkPos subtable
	uint16_t classCount; //Number of Combining Mark classes defined
	MarkArray * mark1Array; //Offset to MarkArray table for Mark1-from beginning of MarkMarkPos subtable
	Mark2Array * mark2Array; //Offset to Mark2Array table for Mark2-from beginning of MarkMarkPos subtable
}
@end





@interface Mark2Record : OTBaseTable {
@public
	NSArray * mark2Anchors; //Array of offsets (one per class) to Anchor tables-from beginning of Mark2Array table-zero-based array
}
@end


@interface PosLookupRecord : OTBaseTable {
@public
	uint16_t sequenceIndex; //Index to input glyph sequence-first glyph = 0
	uint16_t lookupIndex; //Lookup to apply to that position-zero-based
}
@end

@interface OTContextPos : OTFormatSwitchingBaseTable {
	OTCoverage * _coverage;
	NSArray * _posRuleSets; //Array of offsets to PosRuleSet tables-from beginning of ContextPos subtable-ordered by Coverage Index
	OTClassDef * _classDef; //Offset to ClassDef table-from beginning of ContextPos subtable
	NSArray * _posClassSets; //Array of offsets to PosClassSet tables-from beginning of ContextPos subtable-ordered by class-may be NULL
	NSArray * _posLookupRecords; //Array of positioning lookups-in design order
@public
	 //Offset to Coverage table-from beginning of ContextPos subtable
	uint16_t _posSetCount; //Number of PosRuleSet tables
	uint16_t _glyphCount; //Number of glyphs in the input sequence
}
@property (nonatomic, retain) OTCoverage* coverage;
@property (nonatomic, retain) NSArray* posRuleSets;
@property (nonatomic, retain) OTClassDef* classDef;
@property (nonatomic, retain) NSArray* posClassSets;
@property (nonatomic, retain) NSArray* posLookupRecords;

@end
/*
@interface ContextPosFormat1 : ContextPos {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of ContextPos subtable
	uint16_t PosRuleSetCount; //Number of PosRuleSet tables
	NSArray * PosRuleSetOffsets; //Array of offsets to PosRuleSet tables-from beginning of ContextPos subtable-ordered by Coverage Index
}
@end
*/

@interface PosRuleSet : OTBaseTable {
@public
	uint16_t PosRuleCount; //Number of PosRule tables
	NSArray * PosRules; //Array of offsets to PosRule tables-from beginning of PosRuleSet-ordered by preference
}
@end


@interface PosRule : OTBaseTable {
@public
	uint16_t glyphCount; //Number of glyphs in the Input glyph sequence
	uint16_t posCount; //Number of PosLookupRecords
	NSArray * inputGlyphIDs; //-1, 'Array of input GlyphIDs-starting with the second glyph
	NSArray * posLookupRecords; //Array of positioning lookups-in design order
}
@end

/*
@interface ContextPosFormat2 : OTFormatSwitchingBaseTable {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of ContextPos subtable
	NSUInteger ClassDefOffsets; //Offset to ClassDef table-from beginning of ContextPos subtable
	uint16_t PosClassSetCount; //Number of PosClassSet tables
	NSArray * PosClassSetOffsets; //Array of offsets to PosClassSet tables-from beginning of ContextPos subtable-ordered by class-may be NULL
}
@end
*/

@interface PosClassSet : OTBaseTable {
@public
	uint16_t PosClassRuleCount; //Number of PosClassRule tables
	NSArray * PosClassRuleOffsets; //Array of offsets to PosClassRule tables-from beginning of PosClassSet-ordered by preference
}
@end


@interface PosClassRule : OTBaseTable {
@public
	uint16_t GlyphCount; //Number of glyphs to be matched
	uint16_t PosCount; //Number of PosLookupRecords
	NSArray * classIDs; //-1, 'Array of classes-beginning with the second class-to be matched to the input glyph sequence
	NSArray * posLookupRecords; //Array of positioning lookups-in design order
}
@end

/*
@interface ContextPosFormat3 : OTFormatSwitchingBaseTable {
@public
	uint16_t GlyphCount; //Number of glyphs in the input sequence
	uint16_t PosCount; //Number of PosLookupRecords
	NSArray * CoverageOffsets; //Array of offsets to Coverage tables-from beginning of ContextPos subtable
	NSArray * PosLookupRecords; //Array of positioning lookups-in design order
}
@end
*/
@interface ChainContextPos : OTFormatSwitchingBaseTable {
	
	//1
	OTCoverage * coverage; //Offset to coverage table-from beginning of ContextPos subtable
	uint16_t chainPosRuleSetCount; //Number of ChainPosRuleSet tables
	NSArray * chainPosRuleSets; //Array of offsets to ChainPosRuleSet tables-from beginning of ContextPos subtable-ordered by Coverage Index
	
	//2
	//NSUInteger coverageOffsets; //Offset to Coverage table-from beginning of ChainContextPos subtable
	OTClassDef * _backtrackClassDef; //Offset to ClassDef table containing backtrack sequence context-from beginning of ChainContextPos subtable
	OTClassDef * _inputClassDef; //Offset to ClassDef table containing input sequence context-from beginning of ChainContextPos subtable
	OTClassDef * _lookAheadClassDef; //Offset to ClassDef table containing lookahead sequence context-from beginning of ChainContextPos subtable
	uint16_t chainPosClassSetCount; //Number of ChainPosClassSet tables
	NSArray * _chainPosClassSets; //Array of offsets to ChainPosClassSet tables-from beginning of ChainContextPos subtable-ordered by input class-may be NULL
	
	//3
	uint16_t backtrackGlyphCount; //Number of glyphs in the backtracking sequence
	NSArray * backtrackCoverages; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
	uint16_t inputGlyphCount; //Number of glyphs in input sequence
	NSArray * inputCoverages; //Array of offsets to coverage tables in input sequence, in glyph sequence order
	uint16_t lookAheadGlyphCount; //Number of glyphs in lookahead sequence
	NSArray * lookAheadCoverages; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
	uint16_t posCount; //Number of PosLookupRecords
	NSArray * posLookupRecords; //Array of PosLookupRecords,in design order
	
}
@property (nonatomic, retain) OTCoverage* coverage;
@property (nonatomic, retain) NSArray* chainPosRuleSets;

@property (nonatomic, retain) OTClassDef* backtrackClassDef;
@property (nonatomic, retain) OTClassDef* inputClassDef;
@property (nonatomic, retain) OTClassDef* lookAheadClassDef;
@property (nonatomic, retain) NSArray* chainPosClassSets;

@property (nonatomic, retain) NSArray* backtrackCoverages;
@property (nonatomic, retain) NSArray* inputCoverages;
@property (nonatomic, retain) NSArray* lookAheadCoverages;
@property (nonatomic, retain) NSArray* posLookupRecords;
@end
/*
@interface ChainContextPosFormat1 : OTFormatSwitchingBaseTable {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of ContextPos subtable
	uint16_t ChainPosRuleSetCount; //Number of ChainPosRuleSet tables
	NSArray * ChainPosRuleSetOffsets; //Array of offsets to ChainPosRuleSet tables-from beginning of ContextPos subtable-ordered by Coverage Index
}
@end
*/

@interface ChainPosRuleSet : OTBaseTable {
@public
	uint16_t chainPosRuleCount; //Number of ChainPosRule tables
	NSArray * chainPosRules; //Array of offsets to ChainPosRule tables-from beginning of ChainPosRuleSet-ordered by preference
}
@property (nonatomic, retain) NSArray* chainPosRules;
@end


@interface ChainPosRule : OTBaseTable {
@public
	uint16_t backtrackGlyphCount; //Total number of glyphs in the backtrack sequence (number of glyphs to be matched before the first glyph)
	NSArray * backtrackGlyphIDs; //Array of backtracking GlyphID's (to be matched before the input sequence)
	uint16_t inputGlyphCount; //Total number of glyphs in the input sequence (includes the first glyph)
	NSArray * inputGlyphIDs; //-1, 'Array of input GlyphIDs (start with second glyph)
	uint16_t lookAheadGlyphCount; //Total number of glyphs in the look ahead sequence (number of glyphs to be matched after the input sequence)
	NSArray * lookAheadGlyphIDs; //Array of lookahead GlyphID's (to be matched after the input sequence)
	uint16_t posCount; //Number of PosLookupRecords
	NSArray * posLookupRecords; //Array of PosLookupRecords (in design order)
}
@end


/*
@interface ChainContextPosFormat2 : OTFormatSwitchingBaseTable {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of ChainContextPos subtable
	NSUInteger BacktrackClassDefOffsets; //Offset to ClassDef table containing backtrack sequence context-from beginning of ChainContextPos subtable
	NSUInteger InputClassDefOffsets; //Offset to ClassDef table containing input sequence context-from beginning of ChainContextPos subtable
	NSUInteger LookAheadClassDefOffsets; //Offset to ClassDef table containing lookahead sequence context-from beginning of ChainContextPos subtable
	uint16_t ChainPosClassSetCount; //Number of ChainPosClassSet tables
	NSArray * ChainPosClassSetOffsets; //Array of offsets to ChainPosClassSet tables-from beginning of ChainContextPos subtable-ordered by input class-may be NULL
}
@end
*/

@interface ChainPosClassSet : OTBaseTable {
	uint16_t chainPosClassRuleCount; //Number of ChainPosClassRule tables
	NSArray * chainPosClassRules; //Array of offsets to ChainPosClassRule tables-from beginning of ChainPosClassSet-ordered by preference
}
@property (nonatomic, retain) NSArray* chainPosClassRules;
@end


@interface ChainPosClassRule : OTBaseTable {
@public
	uint16_t backtrackGlyphCount; //Total number of glyphs in the backtrack sequence (number of glyphs to be matched before the first glyph)
	NSArray * _backtracks; //Array of backtracking classes(to be matched before the input sequence)
	uint16_t inputGlyphCount; //Total number of classes in the input sequence (includes the first class)
	NSArray * _inputs; //', 'InputGlyphCount', -1, 'Array of input classes(start with second class; to be matched with the input glyph sequence)
	uint16_t lookAheadGlyphCount; //Total number of classes in the look ahead sequence (number of classes to be matched after the input sequence)
	NSArray * _lookAheads; //Array of lookahead classes(to be matched after the input sequence)
	uint16_t posCount; //Number of PosLookupRecords
	NSArray * _posLookupRecords; //Array of PosLookupRecords (in design order)
}
@property (nonatomic, retain) NSArray* backtracks;
@property (nonatomic, retain) NSArray* inputs;
@property (nonatomic, retain) NSArray* lookAheads;
@property (nonatomic, retain) NSArray* posLookupRecords;
@end

/*
@interface ChainContextPosFormat3 : OTFormatSwitchingBaseTable {
@public
	uint16_t BacktrackGlyphCount; //Number of glyphs in the backtracking sequence
	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
	uint16_t InputGlyphCount; //Number of glyphs in input sequence
	NSArray * InputCoverageOffsets; //Array of offsets to coverage tables in input sequence, in glyph sequence order
	uint16_t LookAheadGlyphCount; //Number of glyphs in lookahead sequence
	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
	uint16_t PosCount; //Number of PosLookupRecords
	NSArray * PosLookupRecords; //Array of PosLookupRecords,in design order
}
@end
*/

@interface OTExtensionPos : OTFormatSwitchingBaseTable {
	NSUInteger extFormat; //Format identifier. Set to 1.
	NSUInteger _extensionLookupType; //Lookup type of subtable referenced by ExtensionOffset (i.e. the extension subtable).
	OTBaseTable * _extSubTable; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
}
@property (nonatomic) NSUInteger extFormat;
@property (nonatomic) NSUInteger extensionLookupType;
@property (nonatomic, retain) OTBaseTable* extSubTable;
@end


@interface ValueRecord_ : OTBaseTable {
@public
	int16_t XPlacement; //Horizontal adjustment for placement-in design units
	int16_t YPlacement; //Vertical adjustment for placement-in design units
	int16_t XAdvance; //Horizontal adjustment for advance-in design units (only used for horizontal writing)
	int16_t YAdvance; //Vertical adjustment for advance-in design units (only used for vertical writing)
	NSUInteger XPlaDeviceOffsets; //Offset to Device table for horizontal placement-measured from beginning of PosTable (may be NULL)
	NSUInteger YPlaDeviceOffsets; //Offset to Device table for vertical placement-measured from beginning of PosTable (may be NULL)
	NSUInteger XAdvDeviceOffsets; //Offset to Device table for horizontal advance-measured from beginning of PosTable (may be NULL)
	NSUInteger YAdvDeviceOffsets; //Offset to Device table for vertical advance-measured from beginning of PosTable (may be NULL)
}
@end

@interface OTAnchor : OTFormatSwitchingBaseTable {
@public
	//1
	int16_t xCoordinate; //Horizontal value-in design units
	int16_t yCoordinate; //Vertical value-in design units
	
	//2
	uint16_t anchorPoint; //Index to glyph contour point
	//3
	OTDevice * xDeviceTable; //Offset to Device table for X coordinate- from beginning of Anchor table (may be NULL)
	OTDevice * yDeviceTable; //Offset to Device table for Y coordinate- from beginning of Anchor table (may be NULL)
}
@property (nonatomic, retain) OTDevice* xDeviceTable;
@property (nonatomic, retain) OTDevice* yDeviceTable;
@end

/*
@interface AnchorFormat1 : OTFormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
}
@end


@interface AnchorFormat2 : OTFormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
	uint16_t AnchorPoint; //Index to glyph contour point
}
@end


@interface AnchorFormat3 : OTFormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
	NSUInteger XDeviceTableOffsets; //Offset to Device table for X coordinate- from beginning of Anchor table (may be NULL)
	NSUInteger YDeviceTableOffsets; //Offset to Device table for Y coordinate- from beginning of Anchor table (may be NULL)
}
@end
*/



//
// gsub (generated from gsub.htm)
//

@interface OTGSUB : OTBaseTable {
	OTScriptList * _scriptList;
	OTLookupList * _lookupList;
	OTFeatureList * _featureList;
	Fixed _version; //Version of the GSUB table-initially set to 0x00010000
	NSUInteger _scriptListOffset; //Offset to ScriptList table-from beginning of GSUB table
	NSUInteger _featureListOffset; //Offset to FeatureList table-from beginning of GSUB table
	NSUInteger _lookupListOffset; //Offset to LookupList table-from beginning of GSUB table
}
@property (retain, nonatomic) OTScriptList * scriptList;
@property (retain, nonatomic) OTLookupList * lookupList;
@property (retain, nonatomic) OTFeatureList * featureList;
- (NSString*) fdkFeatureCodeForFeature:(NSString*) FeatureTag glyphOrder:(NSArray*)GlyphOrder;
@end

@interface OTSingleSubst : OTFormatSwitchingBaseTable {
	OTOrderedDictionary * _mapping;
	OTOrderedDictionary * _idMapping;
	
//	NSUInteger CoverageOffset; //Offset to Coverage table-from beginning of Substitution table
//	int16_t DeltaGlyphID; //Add to original GlyphID to get substitute GlyphID

//	uint16_t GlyphCount; //Number of GlyphIDs in the Substitute array
//	NSArray * _substituteGlyphIDs; //Array of substitute GlyphIDs-ordered by Coverage Index

}
@property (readonly, nonatomic) OTOrderedDictionary * mapping;
@property (readonly, nonatomic) OTOrderedDictionary * idMapping;

@end

//@interface SingleSubstFormat1 : SingleSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	int16_t DeltaGlyphID; //Add to original GlyphID to get substitute GlyphID
//}
//@end
//
//
//@interface SingleSubstFormat2 : SingleSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t GlyphCount; //Number of GlyphIDs in the Substitute array
//	NSArray * SubstituteGlyphIDs; //Array of substitute GlyphIDs-ordered by Coverage Index
//}
//@end

@interface OTMultipleSubst : OTFormatSwitchingBaseTable {
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
	uint16_t _sequenceCount; //Number of Sequence table offsets in the Sequence array
	NSArray * SequenceOffsets; //Array of offsets to Sequence tables-from beginning of Substitution table-ordered by Coverage Index
	OTCoverage * _coverage;
	NSArray * _sequences;
}
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, retain) NSArray *sequences;
@end

//@interface MultipleSubstFormat1 : MultipleSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t SequenceCount; //Number of Sequence table offsets in the Sequence array
//	NSArray * SequenceOffsets; //Array of offsets to Sequence tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface OTSequence : OTBaseTable {
	uint16_t _glyphCount; //Number of GlyphIDs in the Substitute array. This should always be greater than 0.
	NSArray * _substitutes; //String of GlyphIDs to substitute
}
@property (nonatomic, retain) NSArray *substitutes;
@end

@interface OTAlternateSubst : OTFormatSwitchingBaseTable {
	OTOrderedDictionary * _alternateSets;
	
	OTCoverage * _coverage; //Offset to Coverage table-from beginning of Substitution table
	uint16_t _alternateSetCount; //Number of AlternateSet tables
//	NSArray * AlternateSetOffsets; //Array of offsets to AlternateSet tables-from beginning of Substitution table-ordered by Coverage Index

	
}
@property (retain, nonatomic) OTOrderedDictionary * alternateSets;
@property (nonatomic, retain) OTCoverage* coverage;
@end


//@interface AlternateSubstFormat1 : AlternateSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t AlternateSetCount; //Number of AlternateSet tables
//	NSArray * AlternateSetOffsets; //Array of offsets to AlternateSet tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface OTAlternateSet : OTBaseTable {
	NSArray * _alternates;
	uint16_t _glyphCount; //Number of GlyphIDs in the Alternate array
	//NSArray * alternateGlyphIDs; //Array of alternate GlyphIDs-in arbitrary order
}

@property (retain, nonatomic) id alternates;
@end

@interface OTLigatureSubst : OTFormatSwitchingBaseTable {
	//NSArray * _ligatureSets;
	OTOrderedDictionary * _ligatures;
	//OTCoverage * _coverage;
	//NSUInteger CoverageOffset; //Offset to Coverage table-from beginning of Substitution table
	uint16_t _ligSetCount; //Number of LigatureSet tables
	//NSArray * LigatureSetOffsets; //Array of offsets to LigatureSet tables-from beginning of Substitution table-ordered by Coverage Index

}
@property (retain, nonatomic) OTOrderedDictionary * ligatures;
@property (retain, nonatomic) NSArray * ligatureSets;
@end

//@interface LigatureSubstFormat1 : LigatureSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t LigSetCount; //Number of LigatureSet tables
//	NSArray * LigatureSetOffsets; //Array of offsets to LigatureSet tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface OTLigature : OTBaseTable {
	//NSNumber * _ligGlyph; //GlyphName of ligature to substitute
	NSUInteger _ligGlyphIndex;
	NSArray * _components; //-1, 'Array of component Glyph Names-start with the second component-ordered in writing direction
	uint16_t _compCount; //Number of components in the ligature
}
@property (nonatomic, readonly) NSString *ligGlyphName;
@property (nonatomic, assign) NSUInteger ligGlyphIndex;
@property (nonatomic, assign) uint16_t compCount;
@property (nonatomic, retain) NSArray *components;
@end

@interface OTLigatureSet : OTBaseTable {
	NSArray * _ligatures;
@public
	uint16_t _ligatureCount; //Number of Ligature tables
//	NSArray * LigatureOffsets; //Array of offsets to Ligature tables-from beginning of LigatureSet table-ordered by preference
}
@property (retain, nonatomic) NSArray * ligatures;
@end


@interface OTSubstLookupRecord : OTBaseTable {
	uint16_t _sequenceIndex; //Index into current glyph sequence-first glyph = 0
	uint16_t _lookupListIndex; //Lookup to apply to that position-zero-based
}
@property (nonatomic, assign) uint16_t sequenceIndex;
@property (nonatomic, assign) uint16_t lookupListIndex;
@end

@interface OTContextSubst : OTFormatSwitchingBaseTable {
	OTCoverage * _coverage; //Offset to Coverage table-from beginning of Substitution table
	uint16_t _subRuleSetCount; //Number of SubRuleSet tables-must equal GlyphCount in Coverage table
	//NSArray * SubRuleSetOffsets; //Array of offsets to SubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
	NSArray * _subRuleSets; //Array of offsets to SubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
	//NSUInteger ClassDefOffset; //Offset to glyph ClassDef table-from beginning of Substitution table
	OTClassDef * _classDef; //Offset to glyph ClassDef table-from beginning of Substitution table
	uint16_t _subClassSetCount; //Number of SubClassSet tables
	//NSArray * SubClassSetOffsets; //Array of offsets to SubClassSet tables-from beginning of Substitution table-ordered by class-may be NULL
	NSArray * _subClassSets; //Array of offsets to SubClassSet tables-from beginning of Substitution table-ordered by class-may be NULL
	
	uint16_t _glyphCount; //Number of glyphs in the input glyph sequence
	uint16_t _substCount; //Number of SubstLookupRecords
	NSArray * _substLookupRecords; //Array of SubstLookupRecords-in design order

}
@property (nonatomic, retain) OTCoverage * coverage;
@property (nonatomic, assign) uint16_t subRuleSetCount;
@property (nonatomic, retain) NSArray *subRuleSets;
@property (nonatomic, retain) OTClassDef *classDef;
@property (nonatomic, assign) uint16_t subClassSetCount;
@property (nonatomic, retain) NSArray *subClassSets;
@property (nonatomic, assign) uint16_t glyphCount;
@property (nonatomic, assign) uint16_t substCount;
@property (nonatomic, retain) NSArray *substLookupRecords;
@end

//@interface ContextSubstFormat1 : ContextSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t SubRuleSetCount; //Number of SubRuleSet tables-must equal GlyphCount in Coverage table
//	NSArray * SubRuleSetOffsets; //Array of offsets to SubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface SubRuleSet : OTBaseTable {
@public
	uint16_t SubRuleCount; //Number of SubRule tables
	NSArray * SubRuleOffsets; //Array of offsets to SubRule tables-from beginning of SubRuleSet table-ordered by preference
}
@end


@interface SubRule : OTBaseTable {
@public
	uint16_t GlyphCount; //Total number of glyphs in input glyph sequence-includes the first glyph
	uint16_t SubstCount; //Number of SubstLookupRecords
	NSArray * InputGlyphIDs; //-1, 'Array of input GlyphIDs-start with second glyph
	NSArray * SubstLookupRecords; //Array of SubstLookupRecords-in design order
}
@end


//@interface ContextSubstFormat2 : ContextSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	NSUInteger ClassDefOffsets; //Offset to glyph ClassDef table-from beginning of Substitution table
//	uint16_t SubClassSetCount; //Number of SubClassSet tables
//	NSArray * SubClassSetOffsets; //Array of offsets to SubClassSet tables-from beginning of Substitution table-ordered by class-may be NULL
//}
//@end


@interface OTSubClassSet : OTBaseTable {
	NSArray * subClassRules; //Array of offsets to SubClassRule tables-from beginning of SubClassSet-ordered by preference
@public
	uint16_t subClassRuleCount; //Number of SubClassRule tables
}
@property (nonatomic, retain) NSArray* subClassRules;
@end


@interface OTSubClassRule : OTBaseTable {
	NSArray * classIds; //-1, 'Array of classes-beginning with the second class-to be matched to the input glyph class sequence
	NSArray * substLookupRecords; //Array of Substitution lookups-in design order
@public
	uint16_t classCount; //Total number of classes specified for the context in the rule-includes the first class
	uint16_t substCount; //Number of SubstLookupRecords
}
@property (nonatomic, retain) NSArray* classIds;
@property (nonatomic, retain) NSArray* substLookupRecords;
@end


//@interface ContextSubstFormat3 : ContextSubst {
//@public
//	uint16_t GlyphCount; //Number of glyphs in the input glyph sequence
//	uint16_t SubstCount; //Number of SubstLookupRecords
//	NSArray * CoverageOffsets; //Array of offsets to Coverage table-from beginning of Substitution table-in glyph sequence order
//	NSArray * SubstLookupRecords; //Array of SubstLookupRecords-in design order
//}
//@end


@interface OTChainContextSubst : OTFormatSwitchingBaseTable {
//	NSUInteger CoverageOffset; //Offset to Coverage table-from beginning of Substitution table
	uint16_t _chainSubRuleSetCount; //Number of ChainSubRuleSet tables-must equal GlyphCount in Coverage table
//	NSArray * ChainSubRuleSetOffsets; //Array of offsets to ChainSubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
	NSArray * _chainSubRuleSets; //Array of offsets to ChainSubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index

	OTCoverage * _coverage;
//	NSUInteger BacktrackClassDefOffset; //Offset to glyph ClassDef table containing backtrack sequence data-from beginning of Substitution table
	OTClassDef * _backtrackClassDef; //Offset to glyph ClassDef table containing backtrack sequence data-from beginning of Substitution table
//	NSUInteger InputClassDefOffset; //Offset to glyph ClassDef table containing input sequence data-from beginning of Substitution table
	OTClassDef * _inputClassDef; //Offset to glyph ClassDef table containing input sequence data-from beginning of Substitution table
//	NSUInteger LookAheadClassDefOffset; //Offset to glyph ClassDef table containing lookahead sequence data-from beginning of Substitution table
	OTClassDef * _lookAheadClassDef; //Offset to glyph ClassDef table containing lookahead sequence data-from beginning of Substitution table
	uint16_t _chainSubClassSetCount; //Number of ChainSubClassSet tables
//	NSArray * ChainSubClassSetOffsets; //Array of offsets to ChainSubClassSet tables-from beginning of Substitution table-ordered by input class-may be NULL
	NSArray * _chainSubClassSets; //Array of offsets to ChainSubClassSet tables-from beginning of Substitution table-ordered by input class-may be NULL

	uint16_t _backtrackGlyphCount; //Number of glyphs in the backtracking sequence
//	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
	NSArray * _backtrackCoverages;
	uint16_t _inputGlyphCount; //Number of glyphs in input sequence
//	NSArray * InputCoverageOffsets; //Array of offsets to coverage tables in input sequence, in glyph sequence order
	NSArray * _inputCoverages;
	uint16_t _lookAheadGlyphCount; //Number of glyphs in lookahead sequence
//	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
	NSArray * _lookAheadCoverages;
	uint16_t _substCount; //Number of SubstLookupRecords
	NSArray * _substLookupRecords; //Array of SubstLookupRecords, in design order

}
@property (nonatomic, retain) OTCoverage* coverage;

@property (nonatomic, assign) uint16_t chainSubRuleSetCount;
@property (nonatomic, retain) NSArray *chainSubRuleSets;

@property (nonatomic, retain) OTClassDef * backtrackClassDef;
@property (nonatomic, retain) OTClassDef * inputClassDef;
@property (nonatomic, retain) OTClassDef * lookAheadClassDef;

@property (nonatomic, assign) uint16_t chainSubClassSetCount;
@property (nonatomic, retain) NSArray *chainSubClassSets;

@property (nonatomic) uint16_t backtrackGlyphCount;
@property (retain, nonatomic) NSArray * backtrackCoverages;
@property (nonatomic) uint16_t inputGlyphCount;
@property (retain, nonatomic) NSArray * inputCoverages;

@property (nonatomic) uint16_t lookAheadGlyphCount;
@property (retain, nonatomic) NSArray * lookAheadCoverages;


@property (nonatomic) uint16_t substCount;
@property (retain, nonatomic) NSArray * substLookupRecords;
@end

//@interface ChainContextSubstFormat1 : ChainContextSubst {
//@public
//
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t ChainSubRuleSetCount; //Number of ChainSubRuleSet tables-must equal GlyphCount in Coverage table
//	NSArray * ChainSubRuleSetOffsets; //Array of offsets to ChainSubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface OTChainSubRuleSet : OTBaseTable {
@public
	uint16_t _chainSubRuleCount; //Number of ChainSubRule tables
	NSArray * _chainSubRules; //Array of offsets to ChainSubRule tables-from beginning of ChainSubRuleSet table-ordered by preference
}
@property (nonatomic, strong) NSArray* chainSubRules;
@end


@interface OTChainSubRule : OTBaseTable {
	NSArray * _backtrackGlyphIDs; //Array of backtracking GlyphID's (to be matched before the input sequence)
	NSArray * _inputGlyphIDs; //-1, 'Array of input GlyphIDs (start with second glyph)
	NSArray * _lookAheadGlyphIDs; //Array of lookahead GlyphID's (to be matched after the input sequence)
	NSArray * _substLookupRecords; //Array of SubstLookupRecords (in design order)
@public
	uint16_t _backtrackGlyphCount; //Total number of glyphs in the backtrack sequence (number of glyphs to be matched before the first glyph)
	uint16_t _inputGlyphCount; //Total number of glyphs in the input sequence (includes the first glyph)
	uint16_t _lookAheadGlyphCount; //Total number of glyphs in the look ahead sequence (number of glyphs to be matched after the input sequence)
	uint16_t _substCount; //Number of SubstLookupRecords
}
@property (nonatomic, retain) NSArray* backtrackGlyphIDs;
@property (nonatomic, retain) NSArray* inputGlyphIDs;
@property (nonatomic, retain) NSArray* lookAheadGlyphIDs;
@property (nonatomic, retain) NSArray* substLookupRecords;

@end


//@interface ChainContextSubstFormat2 : ChainContextSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	NSUInteger BacktrackClassDefOffsets; //Offset to glyph ClassDef table containing backtrack sequence data-from beginning of Substitution table
//	NSUInteger InputClassDefOffsets; //Offset to glyph ClassDef table containing input sequence data-from beginning of Substitution table
//	NSUInteger LookAheadClassDefOffsets; //Offset to glyph ClassDef table containing lookahead sequence data-from beginning of Substitution table
//	uint16_t ChainSubClassSetCount; //Number of ChainSubClassSet tables
//	NSArray * ChainSubClassSetOffsets; //Array of offsets to ChainSubClassSet tables-from beginning of Substitution table-ordered by input class-may be NULL
//}
//@end


@interface OTChainSubClassSet : OTBaseTable {
@public
	uint16_t _chainSubClassRuleCount; //Number of ChainSubClassRule tables
	//NSArray * ChainSubClassRuleOffsets; //Array of offsets to ChainSubClassRule tables-from beginning of ChainSubClassSet-ordered by preference
	NSArray * _chainSubClassRules;
}
@property (nonatomic, assign) uint16_t chainSubClassRuleCount;
@property (nonatomic, retain) NSArray *chainSubClassRules;
@end


@interface OTChainSubClassRule : OTBaseTable {
	NSArray * _backtracks; //Array of backtracking classes(to be matched before the input sequence)
	NSArray * _inputClassIds; //-1, 'Array of input classes(start with second class; to be matched with the input glyph sequence)
	NSArray * _lookAheads; //Array of lookahead classes(to be matched after the input sequence)
	NSArray * _substLookupRecords; //Array of SubstLookupRecords (in design order)

@public
	uint16_t backtrackGlyphCount; //Total number of glyphs in the backtrack sequence (number of glyphs to be matched before the first glyph)
	uint16_t inputGlyphCount; //Total number of classes in the input sequence (includes the first class)
	uint16_t lookAheadGlyphCount; //Total number of classes in the look ahead sequence (number of classes to be matched after the input sequence)
	uint16_t substCount; //Number of SubstLookupRecords	NSArray * substLookupRecords; //Array of SubstLookupRecords (in design order)
}
@property (nonatomic, retain) NSArray* backtracks;
@property (nonatomic, retain) NSArray* inputClassIds;
@property (nonatomic, retain) NSArray* lookAheads;
@property (nonatomic, retain) NSArray* substLookupRecords;
@end


//@interface ChainContextSubstFormat3 : ChainContextSubst {
//@public
//	uint16_t BacktrackGlyphCount; //Number of glyphs in the backtracking sequence
//	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
//	uint16_t InputGlyphCount; //Number of glyphs in input sequence
//	NSArray * InputCoverageOffsets; //Array of offsets to coverage tables in input sequence, in glyph sequence order
//	uint16_t LookAheadGlyphCount; //Number of glyphs in lookahead sequence
//	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
//	uint16_t SubstCount; //Number of SubstLookupRecords
//	NSArray * SubstLookupRecords; //Array of SubstLookupRecords, in design order
//}
//@end

@interface OTExtensionSubst : OTFormatSwitchingBaseTable {  // Lookup type 7
	NSUInteger _extensionLookupType; //Lookup type of subtable referenced by ExtensionOffset (i.e. the extension subtable).
	//NSArray * _extSubTableOffsets; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
	id _extSubTable; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
}
@property (nonatomic, assign) NSUInteger extensionLookupType;
@property (nonatomic, retain) id extSubTable;

@end


//@interface ExtensionSubstFormat1 : ExtensionSubst {
//@public
//	NSUInteger ExtensionLookupType; //Lookup type of subtable referenced by ExtensionOffset (i.e. the extension subtable).
//	NSArray * ExtSubTableOffsets; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
//}
//@end

@interface ReverseChainSingleSubst : OTFormatSwitchingBaseTable {
	OTCoverage * coverage; //Offset to Coverage table - from beginning of Substitution table
	uint16_t backtrackGlyphCount; //Number of glyphs in the backtracking sequence
	NSArray * backtrackCoverages; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
	uint16_t lookAheadGlyphCount; //Number of glyphs in lookahead sequence
	NSArray * lookAheadCoverages; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
	uint16_t glyphCount; //Number of GlyphIDs in the Substitute array
	NSArray * glyphCountGlyphIDs; //Array of substitute GlyphIDs-ordered by Coverage index
}
@property (nonatomic, retain) OTCoverage* coverage;
@property (nonatomic, retain) NSArray* backtrackCoverages;
@property (nonatomic, retain) NSArray* lookAheadCoverages;
@property (nonatomic, retain) NSArray* glyphCountGlyphIDs;

@end


//@interface ReverseChainSingleSubstFormat1 : ReverseChainSingleSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table - from beginning of Substitution table
//	uint16_t BacktrackGlyphCount; //Number of glyphs in the backtracking sequence
//	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
//	uint16_t LookAheadGlyphCount; //Number of glyphs in lookahead sequence
//	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
//	uint16_t GlyphCount; //Number of GlyphIDs in the Substitute array
//	NSArray * GlyphCountGlyphIDs; //Array of substitute GlyphIDs-ordered by Coverage index
//}
//@end

#pragma mark gdef (generated from gdef.htm)

@interface OTAttachList : OTBaseTable {
@public
	//NSUInteger CoverageOffsets; //Offset to Coverage table - from beginning of AttachList table
	NSArray * _coverage;
	uint16_t _glyphCount; //Number of glyphs with attachment points
	//NSArray * AttachPointOffsets; //Array of offsets to AttachPoint tables-from beginning of AttachList table-in Coverage Index order
	NSArray * _attachPoints;
}
@property (nonatomic, retain) NSArray *coverage;
@property (nonatomic, assign) uint16_t glyphCount;
@property (nonatomic, retain) NSArray *attachPoints;

@end

@interface LigCaretList : OTBaseTable {
@public
	NSArray * _coverage; //Offset to Coverage table - from beginning of LigCaretList table
	uint16_t _ligGlyphCount; //Number of ligature glyphs
//	NSArray * _ligGlyphOffsets; //Array of offsets to LigGlyph tables-from beginning of LigCaretList table-in Coverage Index order
	NSArray * _ligGlyph;
}
@property (nonatomic, strong) NSArray * coverage;
@property (nonatomic, assign) uint16_t ligGlyphCount;
//@property (nonatomic, strong) NSArray *ligGlyphOffsets;
@property (nonatomic, strong) NSArray *ligGlyph;
@end

@interface OTGDEF : OTBaseTable {
	Fixed _version; //Version of the GDEF table-initially 0x00010000
	OTClassDef * _glyphClassDef;
	NSUInteger _glyphClassDefOffset; //Offset to class definition table for glyph type-from beginning of GDEF header (may be NULL)
	OTAttachList * _attachList;
	NSUInteger AttachListOffsets; //Offset to list of glyphs with attachment points-from beginning of GDEF header (may be NULL)
	LigCaretList * _ligCaretList;
	NSUInteger LigCaretListOffsets; //Offset to list of positioning points for ligature carets-from beginning of GDEF header (may be NULL)
	OTClassDef * _markAttachClassDef;
	NSUInteger MarkAttachClassDefOffsets; //Offset to class definition table for mark attachment type-from beginning of GDEF header (may be NULL)
}
@property (nonatomic, retain) OTClassDef *glyphClassDef;
@property (nonatomic, retain) OTAttachList *attachList;
@property (nonatomic, retain) LigCaretList *ligCaretList;
@property (nonatomic, retain) OTClassDef *markAttachClassDef;
@end





@interface OTAttachPoint : OTBaseTable {
	NSArray * _pointIndexes; //Array of contour point indices -in increasing numerical order
@public
	uint16_t pointCount; //Number of attachment points on this glyph
}
@property (nonatomic, retain) NSArray* pointIndexes;
@end


@interface OTLigGlyph : OTBaseTable {
@public
	uint16_t _caretCount; //Number of CaretValues for this ligature (components - 1)
	NSArray * _caretValues;
}
@property (nonatomic, assign) uint16_t caretCount;
@property (nonatomic, retain) NSArray *caretValues;
@end

@interface CaretValue : OTFormatSwitchingBaseTable {
@public
	int16_t _coordinate; //X or Y value, in design units
	
	uint16_t CaretValuePoint; //Contour point index on glyph
	
	int16_t Coordinate; //X or Y value, in design units
	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value-from beginning of CaretValue table

}
@property (nonatomic) int16_t coordinate;
@end


//@interface CaretValueFormat1 : CaretValue {
//@public
//	
//}
//@end


//@interface CaretValueFormat2 : CaretValue {
//@public
//	uint16_t CaretValuePoint; //Contour point index on glyph
//}
//@end


//@interface CaretValueFormat3 : CaretValue {
//@public
//	int16_t Coordinate; //X or Y value, in design units
//	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value-from beginning of CaretValue table
//}
//@end

#pragma mark -
#pragma mark base (generated from base.htm)

@interface BASE : OTBaseTable {
@public
	/*fixed32*/ uint32_t Version; //Version of the BASE table-initially 0x00010000
	NSUInteger HorizAxisOffsets; //Offset to horizontal Axis table-from beginning of BASE table-may be NULL
	NSUInteger VertAxisOffsets; //Offset to vertical Axis table-from beginning of BASE table-may be NULL
}
@end


@interface Axis : OTBaseTable {
@public
	NSUInteger BaseTagListOffsets; //Offset to BaseTagList table-from beginning of Axis table-may be NULL
	NSUInteger BaseScriptListOffsets; //Offset to BaseScriptList table-from beginning of Axis table
}
@end


@interface BaseTagList : OTBaseTable {
@public
	uint16_t BaseTagCount; //Number of baseline identification tags in this text direction-may be zero (0)
	NSArray * BaselineTags; //Array of 4-byte baseline identification tags-must be in alphabetical order
}
@end


@interface BaseScriptList : OTBaseTable {
@public
	uint16_t BaseScriptCount; //Number of BaseScriptRecords defined
	NSArray * BaseScriptRecords; //Array of BaseScriptRecords-in alphabetical order by BaseScriptTag
}
@end


@interface BaseScriptRecord : OTBaseTable {
@public
	NSString * BaseScriptTag; //4-byte script identification tag
	NSUInteger BaseScriptOffsets; //Offset to BaseScript table-from beginning of BaseScriptList
}
@end


@interface BaseScript : OTBaseTable {
@public
	NSUInteger BaseValueOffsets; //Offset to BaseValues table-from beginning of BaseScript table-may be NULL
	NSUInteger DefaultMinMaxOffsets; //Offset to MinMax table- from beginning of BaseScript table-may be NULL
	uint16_t BaseLangSysCount; //Number of BaseLangSysRecords defined-may be zero (0)
	NSArray * BaseLangSysRecords; //Array of BaseLangSysRecords-in alphabetical order by BaseLangSysTag
}
@end


@interface BaseLangSysRecord : OTBaseTable {
@public
	NSString * BaseLangSysTag; //4-byte language system identification tag
	NSUInteger MinMaxOffsets; //Offset to MinMax table-from beginning of BaseScript table
}
@end


@interface BaseValues : OTBaseTable {
@public
	uint16_t DefaultIndex; //Index number of default baseline for this script-equals index position of baseline tag in BaselineArray of the BaseTagList
	uint16_t BaseCoordCount; //Number of BaseCoord tables defined-should equal BaseTagCount in the BaseTagList
	NSArray * BaseCoordOffsets; //Array of offsets to BaseCoord-from beginning of BaseValues table-order matches BaselineTag array in the BaseTagList
}
@end


@interface MinMax : OTBaseTable {
@public
	NSUInteger MinCoordOffsets; //Offset to BaseCoord table-defines minimum extent value-from the beginning of MinMax table-may be NULL
	NSUInteger MaxCoordOffsets; //Offset to BaseCoord table-defines maximum extent value-from the beginning of MinMax table-may be NULL
	uint16_t FeatMinMaxCount; //Number of FeatMinMaxRecords-may be zero (0)
	NSArray * FeatMinMaxRecords; //Array of FeatMinMaxRecords-in alphabetical order, by FeatureTableTag
}
@end


@interface FeatMinMaxRecord : OTBaseTable {
@public
	NSString * FeatureTableTag; //4-byte feature identification tag-must match FeatureTag in FeatureList
	NSUInteger MinCoordOffsets; //Offset to BaseCoord table-defines minimum extent value-from beginning of MinMax table-may be NULL
	NSUInteger MaxCoordOffsets; //Offset to BaseCoord table-defines maximum extent value-from beginning of MinMax table-may be NULL
}
@end

@interface BaseCoord : OTFormatSwitchingBaseTable {
	int16_t Coordinate; //X or Y value, in design units
	NSUInteger ReferenceGlyph; //GlyphID of control glyph
	uint16_t BaseCoordPoint; //Index of contour point on the ReferenceGlyph
	
	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value
}
@end

//@interface BaseCoordFormat1 : BaseCoord {}
//@end
//
//
//@interface BaseCoordFormat2 : BaseCoord {
//@public
//	NSUInteger ReferenceGlyph; //GlyphID of control glyph
//	uint16_t BaseCoordPoint; //Index of contour point on the ReferenceGlyph
//}
//@end


//@interface BaseCoordFormat3 : BaseCoord {
//@public
//	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value
//}
//@end


#pragma mark -
#pragma mark jstf (generated from jstf.htm)

@interface JSTF : OTBaseTable {
@public
	Fixed /*fixed32*/ Version; //Version of the JSTF table-initially set to 0x00010000
	uint16_t JstfScriptCount; //Number of JstfScriptRecords in this table
	NSArray * JstfScriptRecords; //Array of JstfScriptRecords-in alphabetical order, by JstfScriptTag
}
@end


@interface JstfScriptRecord : OTBaseTable {
@public
	NSString * JstfScriptTag; //4-byte JstfScript identification
	NSUInteger JstfScriptOffsets; //Offset to JstfScript table-from beginning of JSTF Header
}
@end


@interface JstfScript : OTBaseTable {
@public
	NSUInteger ExtenderGlyphOffsets; //Offset to ExtenderGlyph table-from beginning of JstfScript table-may be NULL
	NSUInteger DefJstfLangSysOffsets; //Offset to Default JstfLangSys table-from beginning of JstfScript table-may be NULL
	uint16_t JstfLangSysCount; //Number of JstfLangSysRecords in this table- may be zero (0)
	NSArray * JstfLangSysRecords; //Array of JstfLangSysRecords-in alphabetical order, by JstfLangSysTag
}
@end


@interface JstfLangSysRecord : OTBaseTable {
@public
	NSString * JstfLangSysTag; //4-byte JstfLangSys identifier
	NSUInteger JstfLangSysOffsets; //Offset to JstfLangSys table-from beginning of JstfScript table
}
@end


@interface ExtenderGlyph : OTBaseTable {
@public
	uint16_t GlyphCount; //Number of Extender Glyphs in this script
	NSArray * ExtenderGlyphIDs; //GlyphIDs-in increasing numerical order
}
@end


@interface JstfLangSys : OTBaseTable {
@public
	uint16_t JstfPriorityCount; //Number of JstfPriority tables
	NSArray * JstfPriorityOffsets; //Array of offsets to JstfPriority tables-from beginning of JstfLangSys table-in priority order
}
@end


@interface JstfPriority : OTBaseTable {
@public
	NSUInteger ShrinkageEnableGSUBOffsets; //Offset to Shrinkage Enable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageDisableGSUBOffsets; //Offset to Shrinkage Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageEnableGPOSOffsets; //Offset to Shrinkage Enable JstfGPOSModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageDisableGPOSOffsets; //Offset to Shrinkage Disable JstfGPOSModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageJstfMaxOffsets; //Offset to Shrinkage JstfMax table-from beginning of JstfPriority table -may be NULL
	NSUInteger ExtensionEnableGSUBOffsets; //Offset to Extension Enable JstfGSUBModList table-may be NULL
	NSUInteger ExtensionDisableGSUBOffsets; //Offset to Extension Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ExtensionEnableGPOSOffsets; //Offset to Extension Enable JstfGSUBModList table-may be NULL
	NSUInteger ExtensionDisableGPOSOffsets; //Offset to Extension Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ExtensionJstfMaxOffsets; //Offset to Extension JstfMax table-from beginning of JstfPriority table -may be NULL
}
@end


@interface JstfGSUBModList : OTBaseTable {
@public
	uint16_t LookupCount; //Number of lookups for this modification
	NSArray * GSUBLookupIndexs; //Array of LookupIndex identifiers in GSUB-in increasing numerical order
}
@end


@interface JstfGPOSModList : OTBaseTable {
@public
	uint16_t LookupCount; //Number of lookups for this modification
	NSArray * GPOSLookupIndexs; //Array of LookupIndex identifiers in GPOS-in increasing numerical order
}
@end


@interface JstfMax : OTBaseTable {
@public
	uint16_t LookupCount; //Number of lookup Indices for this modification
	NSArray * LookupOffsets; //Array of offsets to GPOS-type lookup tables-from beginning of JstfMax table-in design order
}
@end


NSInteger doModulo(NSInteger value) ;
//NSArray * _getGlyphsFromCoverageTable( OTCoverage * coverage) ;

